/**
 * Created by lei.wang_1 on 2016/9/28.
 */
appModule.directive("contextMenu",["utils", function(utils){
    return{
        template: '<div class="contextMenu hide" ng-transclude ng-click="hideMe($event);">'
                + '</div>',
        restrict: "E",
        transclude: true,
        replace:true,
        scope:{
            selector:"@"
        },
        link:function($scope,element){
            var offContextMenu = $scope.$on("onContextMenu",function(e,uiEvent){
                if($(uiEvent.target).closest($scope.selector).length > 0){
                    utils.getPosition(element,uiEvent);
                    element.removeClass("hide");
                }else{
                    element.addClass("hide");
                }
            });

            var offDocumentClick = $scope.$on("onDocumentClick",function(e,uiEvent){
                element.addClass("hide");
            });

            $scope.$on("$destroy",function(){
                offContextMenu();
                offDocumentClick();
            });
        }
    };
}]);
